/**********************************************************************

SerialCommand.h
COPYRIGHT (c) 2013-2016 Gregg E. Berman

Part of DCC++ BASE STATION for the Arduino

**********************************************************************/

#ifndef SerialCommand_h
#define SerialCommand_h

#include "PacketRegister.h"
#include "CurrentMonitor.h"

#define  MAX_COMMAND_LENGTH         30

//CJR ADDIIONS
#define LOCOS 12
#define SW1_4 A2 //formerly LCD_SHIELD_SW
#define SW56 A5 //formerly HORN_BELL_SW
#define SW78 A4 //formerly THR_MULT_SW
#define SW910 A3 //formerly MUTE_SW
//END CJR ADDITIONS

//end CJR

struct SerialCommand{
  static char commandString[MAX_COMMAND_LENGTH+1];
  static volatile RegisterList *mRegs, *pRegs;
  static CurrentMonitor *mMonitor;
  static void init(volatile RegisterList *, volatile RegisterList *, CurrentMonitor *);
  static void parse(char *);
  static void process();
}; // SerialCommand
  
#endif




